# This code is copyrighted by iuveno AG in June, 2001.
#
# written by Dirk Datzert
# Last updated: October 27, 2001

from DocumentTemplate.DT_String import String
from DocumentTemplate.DT_Util   import render_blocks
import string


class NoBabelTag:
    '''No ZBabel Tag class - The cool null translation tag'''

    # define the name of the tag; also tell the system it is a doublet
    name = 'babel'
    blockContinuations = ()


    def __init__(self, blocks):
        '''__init__(self, blocks) --> Initialize tag object; return None'''
        (tname, args, section,) = blocks[0]

        self.section = section


    def render(self, md):
        '''render(self, md) --> Do the Translation; return string'''
        
        return render_blocks(self.section.blocks, md)


    def __call__(self, md):
        '''__call__(self, md) --> render the tag; do the translation; return string'''
        return self.render(md)


def translate(self, text):
	return text


# register the DTML-BABEL tag
String.commands['babel'] = NoBabelTag
